const htmlContent = `<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Liquidificador WB2000</title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;700&display=swap"
      rel="stylesheet"
    />
    <link rel="stylesheet" href="styles/styles.css" />
    <script src=" https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js "></script>
    <link
      href=" https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css "
      rel="stylesheet"
    />
    <link rel="stylesheet" href="./styles/slider.css" />
  </head>

  <body>
    <main>
      <section class="w-[min(1200px,_90%)] mx-auto">
        <div class="w-full flex-col items-center flex md:mt-10">
          <div
            @click="showVideo = !showVideo"
            x-data="{ showVideo: false }"
            class="hidden md:block w-full aspect-video rounded-2xl overflow-hidden"
          >
            <div x-show="!showVideo" class="relative h-full">
              <img
                src="./images/desktop_liquidificador_wb2000_cover_video.png"
                alt="Video Thumbnail"
                class="h-full object-cover"
              />
              <button
                class="absolute left-1/2 top-1/2 -translate-x-1/2 -translate-y-1/2"
              >
                <svg
                  width="80"
                  height="80"
                  viewBox="0 0 80 80"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <circle
                    cx="40"
                    cy="40"
                    r="40"
                    fill="white"
                    fill-opacity="0.53"
                  />
                  <circle cx="40" cy="40" r="32" fill="white" />
                  <path
                    d="M51 40.5L35.25 49.5933L35.25 31.4067L51 40.5Z"
                    fill="#1A1A1A"
                  />
                </svg>
              </button>
            </div>

            <iframe
              x-show="showVideo"
              loading="lazy"
              :src="showVideo ? 'https://www.youtube.com/embed/FkZ0bcu_Hwk?enablejsapi=1&autoplay=1' : ''"
              frameborder="0"
              class="w-full aspect-video hidden md:block"
              allow="autoplay; encrypted-media"
              allowfullscreen
            ></iframe>
          </div>
          <div class="flex">
            <h1
              class="py-2 text-center text-white rounded-b-lg md:py-2 px-7 text-1xl font-poppins bg-red-primary"
            >
              PROSDÓCIMO
            </h1>
          </div>
        </div>
      </section>
      <section class="mt-36 w-[min(1200px,_90%)] mx-auto">
        <div class="mx-auto max-w-[1000px] relative">
          <header
            class="flex items-center w-max absolute top-0 right-0 max-w-[62%] -mt-7"
          >
            <div class="w-1/4 mr-2 md:mr-4">
              <svg
                class="w-full"
                width="167"
                height="92"
                viewBox="0 0 167 92"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  fill-rule="evenodd"
                  clip-rule="evenodd"
                  d="M160.437 18.6374H131.938C131.407 18.6374 130.954 18.958 130.758 19.4095L114.406 60.9729C114.222 61.4571 113.75 61.8039 113.206 61.8039H105.925C105.217 61.8039 104.64 61.2281 104.64 60.5214C104.64 60.3578 104.673 60.2008 104.725 60.0568L117.81 26.8689C118.066 26.2015 118.204 25.4687 118.204 24.7096C118.204 21.3529 115.475 18.6309 112.11 18.6309H83.5987C83.0674 18.6309 82.6083 18.958 82.4181 19.4161L78.909 28.3281C78.8434 28.4786 78.8106 28.6487 78.8106 28.8189C78.8106 29.5255 79.3878 30.1013 80.0962 30.1013H101.511C102.22 30.1013 102.797 30.6772 102.797 31.3838C102.797 31.554 102.764 31.711 102.705 31.8615L101.065 36.0165C100.882 36.4942 100.416 36.8345 99.8715 36.8345H79.7158C77.1512 36.8345 74.954 38.4179 74.0554 40.6558L64.3088 65.4158C64.053 66.0832 63.9087 66.8161 63.9087 67.5751C63.9087 70.9318 66.6372 73.6539 70.002 73.6539H107.552C108.26 73.6539 108.838 74.2297 108.838 74.9364C108.838 75.1 108.805 75.257 108.752 75.4009L103.223 89.4495C103.171 89.5935 103.138 89.7505 103.138 89.9141C103.138 90.6208 103.708 91.19 104.423 91.19H114.806C115.351 91.19 115.816 90.8563 116.006 90.3787L122.277 74.4325C122.474 73.9745 122.926 73.6539 123.457 73.6539H143.567C146.138 73.6539 148.336 72.0638 149.228 69.8195L166.143 26.8689C166.399 26.2015 166.537 25.4687 166.537 24.7096C166.537 21.3529 163.808 18.6309 160.443 18.6309M95.1359 51.0597L91.2333 60.9663C91.0497 61.4505 90.584 61.7973 90.0265 61.7973H81.526C80.8177 61.7973 80.2405 61.2215 80.2405 60.5148C80.2405 60.3512 80.2667 60.1942 80.3258 60.0503L84.2415 50.1044C84.4382 49.6398 84.8974 49.3126 85.4286 49.3126H93.929C94.6374 49.3126 95.2146 49.8819 95.2146 50.5951C95.2146 50.7587 95.1818 50.9157 95.1293 51.0597M150.251 31.8484L138.786 60.9729C138.602 61.4571 138.13 61.8039 137.579 61.8039H129.105C128.396 61.8039 127.819 61.2281 127.819 60.5214C127.819 60.3578 127.852 60.2008 127.904 60.0568L139.369 30.9389C139.553 30.4547 140.019 30.1079 140.57 30.1079H149.051C149.759 30.1079 150.336 30.6837 150.336 31.3904C150.336 31.554 150.303 31.711 150.251 31.855"
                  fill="black"
                />
                <path
                  fill-rule="evenodd"
                  clip-rule="evenodd"
                  d="M41.6742 73.6607H28.8186C28.1103 73.6607 27.5331 73.0848 27.5331 72.3782V62.4715C27.5331 62.1116 27.2445 61.8237 26.8837 61.8237C26.6673 61.8237 26.4771 61.9284 26.359 62.092L18.4096 73.1241C18.1734 73.4447 17.7996 73.6541 17.3667 73.6541H6.89203C3.52073 73.6541 0.785645 70.9255 0.785645 67.5557V41.3758C0.785645 40.6168 0.923383 39.8904 1.17918 39.2165L15.7401 1.62495C15.9303 1.15383 16.3894 0.82666 16.9272 0.82666H28.0643C28.7727 0.82666 29.3499 1.39593 29.3499 2.10916C29.3499 2.25965 29.3237 2.40361 29.2778 2.53447L14.9661 39.0791C14.671 39.7988 14.507 40.5775 14.507 41.402V54.4625C14.507 54.8224 14.7956 55.1103 15.1563 55.1103C15.3728 55.1103 15.563 55.0056 15.681 54.842L25.7687 40.885C26.0507 40.499 26.2869 40.0737 26.4705 39.6222L41.3528 1.62495C41.543 1.16037 42.0021 0.82666 42.54 0.82666H53.5984C54.3067 0.82666 54.8839 1.39593 54.8839 2.10916C54.8839 2.25965 54.8577 2.40361 54.8118 2.53447L40.1263 39.2623C39.8705 39.9362 39.7327 40.6626 39.7327 41.4216V54.469C39.7327 54.8289 40.0213 55.1168 40.3821 55.1168C40.5985 55.1168 40.7887 55.0121 40.9068 54.8485L51.1519 40.8916C51.4339 40.5055 51.6766 40.0802 51.8602 39.6287L66.8278 1.63149C67.018 1.16691 67.4771 0.833204 68.015 0.833204H79.1521C79.8604 0.833204 80.4376 1.40247 80.4376 2.1157C80.4376 2.2662 80.4114 2.41015 80.3655 2.54102L62.8203 47.0554C62.6497 47.52 62.4267 47.9649 62.1512 48.3641L46.7508 70.9779C45.6489 72.6006 43.7927 73.6672 41.6807 73.6672"
                  fill="black"
                />
              </svg>
            </div>
            <div
              class="flex flex-col justify-center font-uni_sans border-l border-black pl-2 md:pl-5"
            >
              <span
                class="font-bold leading-6 md:leading-8 text-[clamp(15px,4vw,45px)]"
                >LIQUIDIFICADOR</span
              >
              <span class="text-[clamp(14px,4vw,35px)]">WB2000</span>
            </div>
          </header>
          <img
            class="w-full"
            src="images/desktop_liquidificador_wb2000_fogaca_liquidificador.png"
          />
        </div>
      </section>
      <section class="mt-24 pb-10 w-[min(1200px,_90%)] mx-auto">
        <div
          class="max-w-[900px] grid mx-auto font-uni_sans gap-12 justify-center md:grid-cols-3"
        >
          <div class="flex flex-col gap-0.5 max-w-[300px] items-center">
            <div>
              <svg
                width="61"
                height="60"
                viewBox="0 0 61 60"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <mask
                  id="mask0_6028_1684"
                  style="mask-type: luminance"
                  maskUnits="userSpaceOnUse"
                  x="0"
                  y="0"
                  width="61"
                  height="60"
                >
                  <path d="M60.02 0H0.5V59.52H60.02V0Z" fill="white" />
                </mask>
                <g mask="url(#mask0_6028_1684)">
                  <mask
                    id="mask1_6028_1684"
                    style="mask-type: luminance"
                    maskUnits="userSpaceOnUse"
                    x="0"
                    y="0"
                    width="61"
                    height="60"
                  >
                    <path d="M60.02 0H0.5V59.52H60.02V0Z" fill="white" />
                  </mask>
                  <g mask="url(#mask1_6028_1684)">
                    <path
                      d="M51.4988 59.52H9.02115C4.31447 59.52 0.5 55.7034 0.5 50.9988V8.52115C0.5 3.81447 4.31447 0 9.02115 0H51.4988C56.2055 0 60.02 3.81447 60.02 8.52115V50.9988C60.02 55.7055 56.2055 59.52 51.4988 59.52Z"
                      fill="#A32035"
                    />
                  </g>
                </g>
                <path
                  d="M18.3653 20.2897C18.3785 20.254 18.3923 20.2443 18.3988 20.24C18.4102 20.2325 18.431 20.2244 18.4591 20.2244C18.4872 20.2244 18.5079 20.2325 18.5193 20.24C18.5258 20.2443 18.5396 20.254 18.5528 20.2897L19.766 23.5682C19.9584 24.0882 20.3685 24.4983 20.8885 24.6907L24.167 25.9039C24.2027 25.9171 24.2124 25.9309 24.2167 25.9374C24.2242 25.9488 24.2323 25.9695 24.2323 25.9976C24.2323 26.0257 24.2242 26.0465 24.2167 26.0579C24.2124 26.0644 24.2027 26.0782 24.167 26.0914L20.8885 27.3046C20.3685 27.497 19.9584 27.907 19.766 28.4271L18.5528 31.7056C18.5396 31.7413 18.5258 31.751 18.5193 31.7552C18.5079 31.7627 18.4872 31.7709 18.4591 31.7709C18.431 31.7709 18.4102 31.7627 18.3988 31.7552C18.3923 31.751 18.3785 31.7413 18.3653 31.7056L17.1521 28.4271C16.9597 27.907 16.5497 27.497 16.0296 27.3046L12.7511 26.0914C12.7154 26.0782 12.7057 26.0644 12.7015 26.0579C12.694 26.0465 12.6858 26.0257 12.6858 25.9976C12.6858 25.9695 12.694 25.9488 12.7015 25.9374C12.7057 25.9309 12.7154 25.9171 12.7511 25.9039L16.0296 24.6907C16.5497 24.4983 16.9597 24.0882 17.1521 23.5682L18.3653 20.2897Z"
                  stroke="white"
                  stroke-width="1.8"
                />
                <path
                  d="M31.293 27.0065C31.3063 26.9708 31.3201 26.9611 31.3266 26.9568C31.338 26.9493 31.3587 26.9412 31.3868 26.9412C31.4149 26.9412 31.4357 26.9493 31.4471 26.9568C31.4536 26.9611 31.4674 26.9708 31.4806 27.0065L33.8744 33.4755C34.0668 33.9956 34.4768 34.4056 34.9969 34.598L41.4659 36.9918C41.5016 37.005 41.5113 37.0188 41.5156 37.0253C41.5231 37.0367 41.5312 37.0575 41.5312 37.0856C41.5312 37.1137 41.5231 37.1344 41.5156 37.1458C41.5113 37.1523 41.5016 37.1661 41.4659 37.1794L34.9969 39.5731C34.4768 39.7655 34.0668 40.1756 33.8744 40.6956L31.4806 47.1646C31.4674 47.2004 31.4536 47.2101 31.4471 47.2143C31.4357 47.2218 31.4149 47.2299 31.3868 47.2299C31.3587 47.2299 31.338 47.2218 31.3266 47.2143C31.3201 47.2101 31.3063 47.2004 31.293 47.1646L28.8993 40.6956C28.7069 40.1756 28.2968 39.7655 27.7768 39.5731L27.4644 40.4172L27.7768 39.5731L21.3078 37.1794C21.272 37.1661 21.2624 37.1523 21.2581 37.1458C21.2506 37.1344 21.2425 37.1137 21.2425 37.0856C21.2425 37.0575 21.2506 37.0367 21.2581 37.0253C21.2624 37.0188 21.272 37.005 21.3078 36.9918L27.7768 34.598C28.2968 34.4056 28.7069 33.9956 28.8993 33.4755L31.293 27.0065Z"
                  stroke="white"
                  stroke-width="1.8"
                />
                <path
                  d="M40.3501 12.3556C40.3633 12.3199 40.3771 12.3102 40.3836 12.3059C40.395 12.2985 40.4158 12.2903 40.4438 12.2903C40.4719 12.2903 40.4927 12.2985 40.5041 12.3059C40.5106 12.3102 40.5244 12.3199 40.5376 12.3556L42.1877 16.8148C42.3801 17.3349 42.7902 17.7449 43.3102 17.9373L47.7694 19.5874C47.8051 19.6006 47.8148 19.6144 47.8191 19.6209C47.8265 19.6323 47.8347 19.6531 47.8347 19.6812C47.8347 19.7092 47.8265 19.73 47.8191 19.7414C47.8148 19.7479 47.8051 19.7617 47.7694 19.7749L43.3102 21.425C42.7902 21.6174 42.3801 22.0275 42.1877 22.5475L40.5376 27.0067C40.5244 27.0424 40.5106 27.0521 40.5041 27.0564C40.4927 27.0638 40.4719 27.072 40.4438 27.072C40.4158 27.072 40.395 27.0638 40.3836 27.0564C40.3771 27.0521 40.3633 27.0424 40.3501 27.0067L38.7 22.5475C38.5076 22.0275 38.0975 21.6174 37.5775 21.425L33.1183 19.7749C33.0826 19.7617 33.0729 19.7479 33.0686 19.7414C33.0612 19.73 33.053 19.7092 33.053 19.6812C33.053 19.6531 33.0612 19.6323 33.0686 19.6209C33.0729 19.6144 33.0826 19.6006 33.1183 19.5874L37.5775 17.9373C38.0975 17.7449 38.5076 17.3348 38.7 16.8148L40.3501 12.3556Z"
                  stroke="white"
                  stroke-width="1.8"
                />
              </svg>
            </div>
            <header
              class="font-bold text-2xl text-center line-clamp-2 leading-6 h-12 mt-6"
            >
              Jarra de vidro
            </header>
            <article class="text-lg text-center md:text-base">
              Possui capacidade total de 2 litros, não mancha e nem absorve
              odores.
            </article>
          </div>
          <div class="flex flex-col gap-0.5 max-w-[300px] items-center">
            <div>
              <svg
                width="61"
                height="60"
                viewBox="0 0 61 60"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <rect
                  x="0.5"
                  width="59.52"
                  height="59.52"
                  rx="8"
                  fill="#A32035"
                />
                <path
                  d="M29.9548 27.3462C28.5662 27.3462 27.4336 28.4788 27.4336 29.8674C27.4336 31.256 28.5662 32.3886 29.9548 32.3886C31.3434 32.3886 32.476 31.256 32.476 29.8674C32.476 28.4788 31.3434 27.3462 29.9548 27.3462ZM29.9548 30.8464C29.4109 30.8464 28.9758 30.4049 28.9758 29.8674C28.9758 29.3299 29.4173 28.8883 29.9548 28.8883C30.4923 28.8883 30.9338 29.3299 30.9338 29.8674C30.9338 30.4049 30.4923 30.8464 29.9548 30.8464Z"
                  fill="white"
                />
                <path
                  d="M46.0412 34.1609L39.3862 29.4065L45.5357 24.4921C46.4571 23.7562 46.7003 22.4828 46.1116 21.4653L44.9278 19.3921C44.3455 18.3746 43.1233 17.9331 42.0226 18.3554L34.3054 21.299L32.7377 14.0489C32.5009 12.9035 31.4579 12.1164 30.2869 12.1804L27.9064 12.3212C26.7354 12.3916 25.8012 13.2874 25.686 14.4584L25.0397 21.1006L22.7872 20.2175L22.0706 20.5503L21.5586 19.4049L20.4004 19.8912L19.8821 18.7458L18.8071 19.2129L18.5895 18.573L17.924 18.3106C16.8234 17.8819 15.6012 18.3106 15.0125 19.3217L13.8094 21.3822C13.2143 22.3996 13.4511 23.673 14.3598 24.4153L21.4051 30.1424L14.9229 36.0231C14.0526 36.8101 13.8862 38.0963 14.5325 39.0818L15.8443 41.0783C16.2987 41.7694 17.0409 42.1469 17.8216 42.1469C18.1544 42.1469 18.4871 42.0765 18.8071 41.9293L25.4172 38.9282L26.3835 45.3144C26.5563 46.479 27.5417 47.3237 28.7191 47.3301L31.1059 47.3429H31.1187C32.2898 47.3429 33.2752 46.5046 33.4608 45.3464L34.6638 37.8404L37.9017 38.877L38.5992 38.4995L39.1815 39.6065L40.3077 39.0498L40.8964 40.1632L41.9394 39.6257L42.1954 40.2528L42.8737 40.4704C43.9935 40.8351 45.1901 40.3296 45.7149 39.2801L46.7835 37.1493C47.3082 36.0998 47.001 34.8392 46.0412 34.1546V34.1609ZM42.5729 19.7952C42.9633 19.648 43.3856 19.8016 43.5904 20.1599L44.7742 22.2332C44.979 22.5916 44.8958 23.0395 44.5694 23.2955L38.0808 28.4786L35.4509 26.5973L34.6382 22.8219L42.5729 19.7952ZM33.4224 35.8247L30.5492 34.9032L26.6266 36.6886L25.8844 31.8125L23.7663 30.0912L25.9036 28.1523L26.3771 23.2763L29.8709 24.6456L33.1856 23.3786L34.0751 27.506L36.833 29.4769L34.0815 31.6781L33.416 35.8311L33.4224 35.8247ZM27.2153 14.612C27.2537 14.2025 27.5865 13.8825 27.996 13.8633L30.3765 13.7226C30.3765 13.7226 30.4084 13.7226 30.4276 13.7226C30.818 13.7226 31.1571 13.9913 31.2403 14.3816L32.8593 21.8621L29.8773 23.0011L26.5307 21.6893L27.2153 14.6184V14.612ZM15.3324 23.2251C15.0125 22.9627 14.9293 22.5148 15.1404 22.1628L16.3434 20.1024C16.497 19.84 16.7722 19.6864 17.0601 19.6864C17.1625 19.6864 17.2649 19.7056 17.3673 19.744L17.8984 21.2926L19.1142 20.7614L19.6261 21.8877L20.778 21.4077L21.3155 22.6044L22.8512 21.8877L24.8989 22.6875L24.4382 27.4036L22.5697 29.0993L15.3324 23.2251ZM18.1672 40.5344C17.7896 40.7071 17.3545 40.5791 17.1241 40.2336L15.8123 38.2371C15.582 37.8916 15.6396 37.4372 15.9467 37.1621L22.6081 31.1278L24.451 32.6252L25.1677 37.3477L18.1672 40.5344ZM31.9314 45.1032C31.8674 45.5064 31.5219 45.8007 31.1123 45.8007L28.7255 45.7879C28.316 45.7879 27.9704 45.4872 27.9064 45.0776L26.8698 38.2627L30.6452 36.5478L33.1728 37.3604L31.9314 45.1032ZM45.4077 36.4646L44.3391 38.5955C44.1535 38.9666 43.7376 39.1394 43.3408 39.0114L42.7137 37.5012L41.5363 38.1091L40.954 37.0213L39.8406 37.5716L39.2327 36.407L37.7417 37.2133L34.9069 36.3046L35.5148 32.5036L38.1448 30.4047L45.1517 35.4152C45.4909 35.6519 45.5997 36.0998 45.4141 36.4646H45.4077Z"
                  fill="white"
                />
              </svg>
            </div>
            <header
              class="font-bold text-2xl text-center line-clamp-2 leading-6 h-12 mt-6"
            >
              6 lâminas em aço inox
            </header>
            <article class="text-lg text-center md:text-base">
              Precisão e eficiência para cortar com rapidez desde frutas macias
              até gelo.
            </article>
          </div>
          <div class="flex flex-col gap-0.5 max-w-[300px] items-center">
            <div>
              <svg
                width="61"
                height="60"
                viewBox="0 0 61 60"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <rect
                  x="0.5"
                  width="59.5196"
                  height="59.4144"
                  rx="8"
                  fill="#A32035"
                />
                <path
                  d="M38.0607 25.2945C37.6602 24.894 37.0039 24.894 36.6035 25.2945L32.3876 29.5104L32.2374 29.427C31.6311 29.0988 30.947 28.9264 30.2574 28.9264C27.9603 28.9264 26.0859 30.7952 26.0859 33.0978C26.0859 35.4004 27.9547 37.2692 30.2574 37.2692C32.56 37.2692 34.4288 35.4004 34.4288 33.0978C34.4288 32.4081 34.2563 31.724 33.9282 31.1178L33.8503 30.9676L38.0662 26.7517C38.4667 26.3512 38.4667 25.6949 38.0662 25.2945M30.2629 35.2058C29.1005 35.2058 28.155 34.2602 28.155 33.0978C28.155 31.9354 29.1005 30.9899 30.2629 30.9899C31.4253 30.9899 32.3709 31.9354 32.3709 33.0978C32.3709 34.2602 31.4253 35.2058 30.2629 35.2058Z"
                  fill="white"
                />
                <path
                  d="M41.4757 42.4585C41.6926 42.6253 41.9651 42.6977 42.2376 42.6587C42.5102 42.6198 42.7493 42.4807 42.9162 42.2583C45.013 39.4884 46.1198 36.1847 46.1198 32.7085C46.1198 23.9652 39.0062 16.8516 30.2629 16.8516C21.5196 16.8516 14.4004 23.9652 14.4004 32.7029C14.4004 36.1847 15.5072 39.4829 17.604 42.2527C17.9489 42.7032 18.5941 42.7978 19.0446 42.4529C19.2615 42.2861 19.4061 42.0469 19.445 41.7744C19.484 41.5018 19.4117 41.2293 19.2448 41.0124C17.4205 38.6041 16.4583 35.7286 16.4583 32.7029C16.4583 25.0998 22.6487 18.9095 30.2629 18.9095C37.8771 18.9095 44.0619 25.0998 44.0619 32.7029C44.0619 35.7286 43.0997 38.6041 41.2754 41.0124C40.9306 41.4629 41.0251 42.1137 41.4757 42.4529"
                  fill="white"
                />
              </svg>
            </div>
            <header
              class="font-bold text-2xl text-center line-clamp-2 leading-6 h-12 mt-6"
            >
              Velocidade variável
            </header>
            <article class="text-lg text-center md:text-base">
              Permite ajuste personalizado durante o uso e vem com 4 funções
              pré-programadas.
            </article>
          </div>
        </div>
      </section>
      <section
        class="bg-zinc-primary relative mt-[clamp(150px,55vw,500px)] max-w-[1200px] mx-auto text-white font-uni_sans md:mt-[180px] md:rounded-3xl md:w-[95%]"
      >
        <div class="md:flex md:flex-row-reverse md:max-w-[80%] md:mx-auto">
          <div class="relative md:static md:basis-[60%]">
            <img
              class="absolute -top-[clamp(150px,55vw,500px)] left-1/2 -translate-x-1/2 max-w-[68%] mx-auto md:translate-x-0 md:-top-[min(10vw,120px)] md:right-0 md:max-w-[55%] md:max-h-[700px]"
              src="images/desktop_liquidificador_wb2000_liquidificador_frutos.png"
            />
          </div>
          <header
            class="pt-[clamp(150px,55vw,500px)] md:basis-[40%] md:py-[min(10vw,120px)]"
          >
            <h3
              class="text-center font-bold text-2xl mt-8 w-[min(700px,85%)] mx-auto md:w-full md:text-left"
            >
              PREPARE SUAS RECEITAS COM MÁXIMO DESEMPENHO
            </h3>
            <p
              class="mt-6 w-4/5 mx-auto text-center md:w-full md:text-left text-lg md:text-base"
            >
              A busca por uma solução confiável e versátil para suas
              necessidades diárias na cozinha acabou. O
              <strong>WAP LIQUIDIFICADOR PROSDÓCIMO WB2000</strong> processa
              alimentos, prepara milk-shakes, sucos, vitaminas, coquetéis e
              molhos com máximo desempenho e precisão do café da manhã ao
              jantar. 
            </p>
          </header>
        </div>
        <div class="mt-16 pb-[145px] md:pb-[210px] md:mt-28">
          <h3 class="text-center font-bold text-2xl w-[min(700px,90%)] mx-auto">
            CONTROLE TOTAL EM QUALQUER DESAFIO
          </h3>
          <p
            class="mt-6 w-4/5 mx-auto text-center max-w-[700px] text-lg md:text-base"
          >
            A velocidade variável do liquidificador WAP permite que você assuma
            o controle do preparo do início ao fim com facilidade. Além disso,
            os quatro modos de uso pré-definidos potencializam a experiência de
            autonomia e confiança durante o uso.
          </p>
        </div>
        <div
          class="text-black absolute bottom-0 translate-y-3/4 md:translate-y-2/4 w-full"
        >
          <div
            class="grid grid-cols-4 max-w-[90%] mx-auto gap-1.5 md:gap-4 md:max-w-[80%]"
          >
            <div class="text-center">
              <div class="relative">
                <div
                  class="absolute left-1/2 -translate-x-1/2 top-0 -translate-y-1/2"
                >
                  <svg
                    width="45"
                    height="45"
                    viewBox="0 0 81 81"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <rect
                      width="80.9998"
                      height="80.8566"
                      rx="8"
                      fill="#A32035"
                    />
                    <path
                      d="M58.2618 58.742L52.0239 57.4254C59.5355 52.3351 62.9653 42.9045 60.3949 34.1475C57.7554 25.1915 49.5072 19.0525 40.2078 19.0525C40.0313 19.0525 39.8472 19.0525 39.6707 19.0525C37.8599 19.0984 36.0415 19.3816 34.2614 19.9022C33.6629 20.0782 33.3253 20.7059 33.4941 21.303C33.5785 21.5938 33.7703 21.8311 34.0389 21.9766C34.3074 22.122 34.6066 22.1526 34.8982 22.0684C36.4865 21.6092 38.1131 21.3489 39.7244 21.3106C39.8855 21.3106 40.0467 21.3106 40.2001 21.3106C48.5021 21.3106 55.8679 26.7914 58.2158 34.7829C60.5483 42.7284 57.3948 51.1945 50.52 55.7031L52.0162 48.9823C52.0853 48.6914 52.0315 48.3852 51.8627 48.1326C51.6939 47.88 51.4484 47.704 51.1568 47.6351C50.543 47.5049 49.9445 47.8877 49.8141 48.4924L47.7731 57.6627C47.7041 57.9536 47.7578 58.2598 47.9266 58.52C48.0877 58.7726 48.3486 58.9487 48.6402 59.0099L57.7861 60.9466C57.8629 60.9619 57.9396 60.9695 58.0163 60.9695C58.1237 60.9695 58.2312 60.9542 58.3386 60.9236C58.7376 60.8088 59.0368 60.4873 59.1289 60.0739C59.1902 59.7831 59.1289 59.4769 58.9754 59.2243C58.822 58.9717 58.5534 58.7956 58.2618 58.7344V58.742Z"
                      fill="white"
                    />
                    <path
                      d="M45.3875 58.2217C43.8145 58.681 42.1956 58.9412 40.5613 58.9795C32.0828 59.2091 24.4638 53.6595 22.0622 45.5149C19.7297 37.5693 22.8909 29.1033 29.7657 24.587L28.2695 31.3078C28.2004 31.5987 28.2541 31.9049 28.4229 32.1575C28.5917 32.4101 28.8373 32.5861 29.1288 32.655C29.313 32.6933 29.5125 32.6856 29.6966 32.6397C30.0956 32.5249 30.3948 32.2034 30.4792 31.7977L32.5202 22.6274C32.5893 22.3365 32.5279 22.0227 32.3667 21.7777C32.2056 21.5251 31.9524 21.3491 31.6532 21.2802L22.4995 19.3435C22.2003 19.2823 21.9087 19.3435 21.6555 19.4966C21.4023 19.665 21.2259 19.9176 21.1645 20.2085C21.034 20.8132 21.4254 21.4103 22.0315 21.5481L28.2695 22.8647C20.7578 27.9551 17.3281 37.3933 19.8985 46.1426C22.5302 55.0986 30.7785 61.23 40.0779 61.23C40.2544 61.23 40.4385 61.23 40.615 61.23C42.4411 61.184 44.2596 60.8932 46.0166 60.3803C46.3082 60.2961 46.546 60.1047 46.6918 59.8368C46.8376 59.5689 46.8683 59.2627 46.7839 58.9795C46.6074 58.3824 45.9859 58.038 45.3875 58.214V58.2217Z"
                      fill="white"
                    />
                    <path
                      d="M48.4263 37.4544C48.4263 36.7119 48.2959 35.977 48.035 35.2575C47.7741 34.5303 47.3752 33.8643 46.8457 33.2672C46.3163 32.6855 45.6565 32.2032 44.8815 31.8435C44.1066 31.4837 43.1935 31.2847 42.1653 31.2617H35.0757V50.697H37.178V43.5398H42.196C43.2165 43.5398 44.1296 43.3561 44.9045 43.004C45.6718 42.6519 46.3317 42.1773 46.8611 41.5955C47.3828 41.0214 47.7741 40.3631 48.035 39.6359C48.2959 38.9241 48.4263 38.1892 48.4263 37.4467V37.4544ZM46.324 37.4314C46.324 37.9366 46.2396 38.4418 46.0708 38.9317C45.9097 39.3986 45.6565 39.8197 45.3188 40.1871C44.9812 40.5545 44.5439 40.8607 44.0222 41.0903C43.5081 41.3276 42.8866 41.4424 42.1653 41.4424H37.1704V33.3132H42.1653C42.8636 33.3132 43.4774 33.4356 43.9915 33.6729C44.5132 33.9179 44.9429 34.2317 45.2805 34.6145C45.6258 35.0049 45.8866 35.4412 46.0554 35.9234C46.2319 36.421 46.324 36.9338 46.324 37.4314Z"
                      fill="white"
                    />
                  </svg>
                </div>
                <div
                  class="w-full aspect-[21/44] md:aspect-[29/35] rounded-xl overflow-hidden"
                >
                  <img
                    class="w-full h-full object-cover md:hidden"
                    src="images/mobile_liquidificador_wb2000_agua.png"
                    alt="liquidificador wb2000"
                  />
                  <img
                    class="hidden w-full h-full object-cover md:block"
                    src="images/desktop_liquidificador_wb2000_agua.png"
                    alt="liquidificador wb2000"
                  />
                  >
                </div>
              </div>
              <div>
                <h4 class="font-bold text-xl mt-4">Limpar</h4>
                <span class="text-zinc-primary mt-1.5">
                  Simplifica a limpeza da jarra;
                </span>
              </div>
            </div>
            <div class="text-center">
              <div class="relative aspect-square">
                <div
                  class="absolute left-1/2 -translate-x-1/2 top-0 -translate-y-1/2"
                >
                  <svg
                    width="45"
                    height="45"
                    viewBox="0 0 81 81"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <rect
                      x="0.000976562"
                      width="80.9998"
                      height="80.8566"
                      rx="8"
                      fill="#A32035"
                    />
                    <path
                      d="M56.3086 18.672L49.7046 17.6999C49.1822 17.6264 48.6676 18.0103 48.5897 18.5739L47.732 24.741H39.1397C39.0618 24.3816 38.9838 24.0222 38.8591 23.6791C37.7675 20.6814 34.9762 18.6638 31.9198 18.6638C27.8264 18.6638 24.4971 22.1517 24.4971 26.44C24.4971 29.8707 26.688 32.942 29.8302 33.8977C30.2122 34.0121 30.6021 34.0938 30.9919 34.1428L32.3252 61.621C32.3486 62.1683 32.7852 62.6012 33.3076 62.6012H49.4239C49.9463 62.6012 50.3829 62.1683 50.4063 61.621L52.1451 25.8192C52.1607 25.5334 52.0593 25.2638 51.8722 25.0596C51.685 24.8554 51.4277 24.741 51.1548 24.741H49.728L50.4063 19.889L56.0357 20.714C56.5581 20.7876 57.0727 20.4036 57.1507 19.84C57.2287 19.2764 56.8544 18.7536 56.3164 18.672H56.3086ZM32.6059 26.7994H37.3231C37.2217 28.4168 36.5122 29.9034 35.2881 30.9163C34.8592 31.2675 34.789 31.921 35.1243 32.3621C35.4596 32.8113 36.0833 32.8849 36.5044 32.5336C38.2041 31.1287 39.1865 29.0457 39.2879 26.7994H47.4357L46.235 35.3925H33.0269L32.6137 26.7994H32.6059ZM30.3838 31.921C28.0759 31.2185 26.4697 28.9641 26.4697 26.44C26.4697 23.2871 28.9101 20.7304 31.9198 20.7304C34.1653 20.7304 36.2159 22.2088 37.019 24.4143C37.058 24.5205 37.0736 24.6348 37.1047 24.741H31.5767C31.3038 24.741 31.0465 24.8554 30.8594 25.0596C30.6723 25.2638 30.5787 25.5415 30.5865 25.8192L30.8828 31.9945C30.719 31.9618 30.5397 31.97 30.376 31.921H30.3838ZM48.4883 60.5346H34.2433L33.1283 37.4591H45.9621L43.3735 56.0421C43.2955 56.6057 43.6698 57.1284 44.2078 57.2101C44.2545 57.2101 44.3013 57.2183 44.3559 57.2183C44.8393 57.2183 45.2526 56.8507 45.3305 56.3361L47.9659 37.4509H49.6188L48.5039 60.5265L48.4883 60.5346ZM50.1179 26.7994L49.7046 35.3925H48.2388L49.4395 26.7994H50.1179Z"
                      fill="white"
                    />
                  </svg>
                </div>
                <div
                  class="w-full aspect-[21/44] md:aspect-[29/35] rounded-xl overflow-hidden"
                >
                  <img
                    class="w-full h-full object-cover md:hidden"
                    src="images/mobile_liquidificador_wb2000_vitamina.png"
                    alt="liquidificador wb2000"
                  />
                  <img
                    class="hidden w-full h-full object-cover md:block"
                    src="images/desktop_liquidificador_wb2000_vitamina.png"
                    alt="liquidificador wb2000"
                  />
                  >
                </div>
              </div>
              <div>
                <h4 class="font-bold text-xl mt-4">Vitamina</h4>
                <span class="text-zinc-primary mt-1.5">
                  Ideal para preparar vitaminas;
                </span>
              </div>
            </div>
            <div class="text-center">
              <div class="relative aspect-square">
                <div
                  class="absolute left-1/2 -translate-x-1/2 top-0 -translate-y-1/2"
                >
                  <svg
                    width="45"
                    height="45"
                    viewBox="0 0 60 60"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <rect
                      width="59.5196"
                      height="59.4144"
                      rx="8"
                      fill="#A32035"
                    />
                    <path
                      d="M23.2715 30.731C23.2715 34.1531 26.0286 36.9361 29.4189 36.9361C32.8091 36.9361 35.5662 34.1531 35.5662 30.731C35.5662 26.8789 31.111 22.0593 29.4189 22.0593C27.7267 22.0593 23.2715 26.8789 23.2715 30.731ZM24.9163 30.731C24.9163 27.6732 28.7325 23.8152 29.4189 23.7196C30.1052 23.8211 33.9214 27.6732 33.9214 30.731C33.9214 33.2393 31.9039 35.2758 29.4189 35.2758C26.9339 35.2758 24.9163 33.2393 24.9163 30.731Z"
                      fill="white"
                    />
                    <path
                      d="M44.8314 29.4411C44.8314 22.4178 40.1395 16.2545 33.4301 14.4568C32.1461 14.1105 30.8149 13.9373 29.4718 13.9373C29.0162 13.9373 28.6494 14.3135 28.6494 14.7674C28.6494 15.2213 29.0162 15.5975 29.4718 15.5975C30.6729 15.5975 31.8621 15.7528 33.01 16.0634C39.0035 17.6759 43.1925 23.1763 43.1925 29.4471C43.1925 35.7179 39.2343 40.9138 33.4833 42.6815L35.921 38.2203C36.1399 37.8202 35.992 37.3125 35.5955 37.0915C35.1991 36.8765 34.6962 37.0199 34.4773 37.42L31.1581 43.4938C31.0516 43.6849 31.0279 43.9178 31.0871 44.1268C31.1462 44.3418 31.2882 44.515 31.4835 44.6225L37.4889 47.8893C37.6072 47.955 37.7433 47.9908 37.8794 47.9908C38.1811 47.9908 38.4592 47.8236 38.6012 47.5549C38.8142 47.1547 38.6663 46.6471 38.2699 46.4321L34.1696 44.1985C40.4827 42.156 44.8314 36.1838 44.8314 29.4411Z"
                      fill="white"
                    />
                    <path
                      d="M29.3655 43.3921C28.1644 43.3921 26.9752 43.2368 25.8274 42.9262C19.8338 41.3197 15.6448 35.8133 15.6448 29.5425C15.6448 23.2717 19.6031 18.0818 25.354 16.314L22.9223 20.7693C22.8158 20.9604 22.7921 21.1874 22.8513 21.4024C22.9104 21.6174 23.0524 21.7906 23.2418 21.8981C23.6145 22.1131 24.147 21.9637 24.36 21.5696L27.6793 15.4958C27.7858 15.3047 27.8094 15.0718 27.7503 14.8628C27.6911 14.6538 27.5491 14.4746 27.3538 14.3671L21.3366 11.0943C20.9402 10.8853 20.4373 11.0346 20.2243 11.4347C20.0113 11.8349 20.1592 12.3425 20.5556 12.5575L24.6559 14.7911C18.3546 16.8336 14 22.8058 14 29.5485C14 36.2911 18.6919 42.7351 25.4073 44.5328C26.6971 44.8791 28.0283 45.0523 29.3655 45.0523C29.8211 45.0523 30.1879 44.6761 30.1879 44.2222C30.1879 43.7683 29.8211 43.3921 29.3655 43.3921Z"
                      fill="white"
                    />
                    <path
                      d="M28.8629 34.4158C28.9457 34.4457 29.0286 34.4576 29.1114 34.4576C29.4723 34.4576 29.7859 34.2247 29.8924 33.8783C29.9575 33.6693 29.9397 33.4424 29.8392 33.2453C29.7386 33.0482 29.567 32.9049 29.3599 32.8332C28.5552 32.5704 28.005 32.1524 27.721 31.585C27.2595 30.6414 27.6323 29.5246 27.6323 29.5126C27.7802 29.0826 27.5553 28.6049 27.1293 28.4556C26.6974 28.3063 26.2359 28.5332 26.0821 28.9632C26.017 29.1483 25.4963 30.7907 26.2418 32.3136C26.727 33.305 27.6086 34.0097 28.857 34.4099L28.8629 34.4158Z"
                      fill="white"
                    />
                  </svg>
                </div>
                <div
                  class="w-full aspect-[21/44] md:aspect-[29/35] rounded-xl overflow-hidden"
                >
                  <img
                    class="w-full h-full object-cover md:hidden"
                    src="images/mobile_liquidificador_wb2000_pulsar.png"
                    alt="liquidificador wb2000"
                  />
                  <img
                    class="hidden w-full h-full object-cover md:block"
                    src="images/desktop_liquidificador_wb2000_pulsar.png"
                    alt="liquidificador wb2000"
                  />
                  >
                </div>
              </div>
              <div>
                <h4 class="font-bold text-xl mt-4">Pulsar</h4>
                <span class="text-zinc-primary mt-1.5">
                  Facilita picar alimentos difíceis;
                </span>
              </div>
            </div>
            <div class="text-center">
              <div class="relative aspect-square">
                <div
                  class="absolute left-1/2 -translate-x-1/2 top-0 -translate-y-1/2"
                >
                  <svg
                    width="45"
                    height="45"
                    viewBox="0 0 60 60"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <rect
                      width="59.5196"
                      height="59.4144"
                      rx="8"
                      fill="#A32035"
                    />
                    <path
                      d="M50.7018 34.3084C50.4965 33.6785 50.2913 33.0421 50.0926 32.4122L49.7152 31.2303C49.5695 30.7758 49.2319 30.568 48.8346 30.6848C48.6558 30.7368 48.5234 30.8407 48.4439 30.9901C48.3512 31.1589 48.3446 31.3797 48.424 31.62L48.5896 32.146C48.8478 32.9577 49.106 33.7694 49.3709 34.5811C49.4371 34.7889 49.4106 34.9253 49.2583 35.0876C47.2587 37.2111 45.2656 39.3346 43.2792 41.4646C43.1269 41.6334 43.0011 41.6724 42.7826 41.6204C39.9155 40.984 37.0419 40.3541 34.1682 39.7372C33.9497 39.6918 33.8503 39.6008 33.7841 39.393C32.9101 36.6332 32.0295 33.8798 31.1422 31.1264C31.076 30.9121 31.1025 30.7887 31.2481 30.6264C33.2345 28.5159 35.221 26.3989 37.2008 24.2755C37.3729 24.0936 37.512 24.0547 37.757 24.1066C40.6042 24.743 43.458 25.3664 46.3118 25.9833C46.5568 26.0353 46.6694 26.1457 46.7422 26.373C46.9673 27.1003 47.1991 27.8276 47.4308 28.5484L47.6427 29.2043C47.7884 29.6523 48.1327 29.8731 48.5234 29.7497C48.6955 29.6978 48.8279 29.5939 48.9074 29.4445C49.0001 29.2692 49.0133 29.0484 48.9339 28.8081L48.6293 27.8665C48.4174 27.1977 48.1989 26.5288 47.9936 25.8535C47.8016 25.2365 47.3845 24.8469 46.7422 24.704C44.6631 24.243 42.584 23.7884 40.5048 23.3339L37.9291 22.7689C37.2802 22.626 36.7108 22.8079 36.2473 23.3079C35.5587 24.0482 34.8634 24.7885 34.1615 25.5353L32.9631 26.8275C32.5923 27.2172 32.2215 27.6133 31.8507 28.0094C31.3276 28.5679 30.8045 29.1263 30.2748 29.6783C29.7318 30.2368 29.5928 30.8667 29.8378 31.6135C30.0298 32.1979 30.2152 32.7823 30.4006 33.3603C30.5595 33.8668 30.725 34.3798 30.8906 34.8798L31.7381 37.5488C31.9765 38.3021 32.2215 39.0489 32.4598 39.8022C32.6717 40.471 33.1087 40.8866 33.7643 41.0295L42.584 42.9581C42.7296 42.9906 42.8687 43.0036 43.0011 43.0036C43.4514 43.0036 43.8487 42.8283 44.1665 42.4906C46.239 40.2892 48.3115 38.0813 50.3707 35.8734C50.7746 35.4383 50.8872 34.8993 50.7018 34.3149V34.3084Z"
                      fill="white"
                    />
                    <path
                      d="M44.2527 29.5874L45.2393 28.5354C45.4512 28.3081 45.6697 28.0808 45.8749 27.847C46.0802 27.6198 46.1067 27.334 45.9478 27.0678C45.7955 26.821 45.5306 26.7106 45.226 26.7496C45.0141 26.7821 44.8817 26.9249 44.7758 27.0418L43.7164 28.1717C42.5245 29.4445 41.3393 30.7108 40.154 31.9836C40.0547 32.094 39.9885 32.1135 39.8495 32.081C38.6444 31.8083 37.4393 31.5485 36.2276 31.2823L34.559 30.9186C34.0557 30.8082 33.5525 30.6978 33.0493 30.5939C32.6719 30.5095 32.3209 30.7368 32.2348 31.1004C32.1554 31.4511 32.3673 31.7888 32.7447 31.8992C32.791 31.9122 32.8374 31.9252 32.8904 31.9317L34.5391 32.2953C36.1812 32.6525 37.8233 33.0161 39.4654 33.3668C39.6839 33.4122 39.7634 33.4902 39.8296 33.698C40.0481 34.4318 40.2865 35.1591 40.5182 35.8864L41.5909 39.2437C41.6836 39.5424 41.7763 39.8411 41.8822 40.1333C41.9882 40.4256 42.2332 40.5944 42.5113 40.5944C42.5709 40.5944 42.6371 40.5879 42.6967 40.5684C43.0608 40.471 43.2661 40.1268 43.18 39.7567C43.1668 39.6918 43.1469 39.6203 43.1204 39.5554L42.6437 38.0748C42.1272 36.4578 41.6107 34.8409 41.0877 33.2239C41.0347 33.0681 41.0546 33.0031 41.1605 32.8927C42.2001 31.8018 43.2264 30.6978 44.2527 29.6004V29.5874Z"
                      fill="white"
                    />
                    <path
                      d="M35.9691 29.0745C36.1081 29.0485 36.2207 28.9381 36.3134 28.8407L36.8762 28.2368C37.4059 27.6719 37.9356 27.1134 38.4587 26.5419C38.6309 26.3536 38.7236 26.1523 38.7103 25.9575C38.7037 25.7951 38.6243 25.6393 38.4852 25.5224C38.1806 25.2497 37.7767 25.2951 37.4523 25.6328C37.1344 25.9705 36.8166 26.3082 36.4988 26.6458L35.8168 27.3666C35.6181 27.5744 35.4195 27.7822 35.2275 27.9965C35.0156 28.2303 34.9957 28.5355 35.1745 28.8083C35.3003 29.0031 35.4857 29.1005 35.7108 29.1005C35.7903 29.1005 35.8698 29.0875 35.9558 29.0615L35.9691 29.0745Z"
                      fill="white"
                    />
                    <path
                      d="M29.7185 23.217C28.2816 21.6195 26.8448 20.0285 25.4079 18.431L23.7393 16.5803C23.2957 16.0868 22.7263 15.9114 22.0575 16.0413C21.051 16.2491 20.0446 16.4439 19.0381 16.6452L17.2967 17.0024C16.767 17.1063 16.2307 17.2102 15.701 17.3141C14.9395 17.4635 14.178 17.6193 13.4099 17.7557C12.6419 17.8921 12.1453 18.3271 11.9003 19.0739C11.7082 19.6584 11.5096 20.2363 11.311 20.8143C11.1388 21.3208 10.9667 21.8208 10.7945 22.3273L9.83439 25.1262C9.59602 25.821 9.35765 26.5158 9.11928 27.2107C8.88753 27.8795 8.99348 28.464 9.43711 28.9575L15.4229 35.6007C15.7605 35.9773 16.1777 36.1721 16.6412 36.1721C16.7538 36.1721 16.8663 36.1591 16.9789 36.1397C19.9784 35.5487 22.9713 34.9578 25.9641 34.3539C26.5534 34.237 26.964 33.8668 27.1626 33.2824C27.3745 32.6525 27.593 32.0291 27.8049 31.3992L28.2088 30.2173C28.3611 29.7627 28.2088 29.4056 27.8247 29.2692C27.646 29.2043 27.4738 29.2173 27.3281 29.2887C27.1494 29.3731 27.0169 29.5484 26.9308 29.7822L26.7719 30.2433C26.4872 31.068 26.2025 31.8927 25.931 32.7239C25.8582 32.9317 25.7589 33.0291 25.5404 33.0681C22.6534 33.6331 19.7665 34.211 16.8796 34.7889C16.6478 34.8344 16.5286 34.7889 16.383 34.6331C14.4429 32.4642 12.4896 30.3017 10.5363 28.1393C10.3906 27.9769 10.3641 27.8471 10.4369 27.6393C11.3838 24.9054 12.3174 22.165 13.251 19.4246C13.3239 19.2103 13.4232 19.1259 13.6351 19.0869C16.5088 18.522 19.3825 17.9505 22.2561 17.3726C22.5011 17.3206 22.6402 17.3726 22.8057 17.5544C24.7325 19.7103 26.666 21.8533 28.6061 24.0027C28.7716 24.1846 28.8047 24.3339 28.7186 24.5677C28.467 25.2755 28.2286 25.9833 27.9837 26.6912L27.7519 27.3795C27.5996 27.8276 27.7519 28.2042 28.1359 28.3276C28.3081 28.3861 28.4736 28.3796 28.6259 28.3016C28.8047 28.2172 28.9504 28.0419 29.0298 27.8016L29.3741 26.7886C29.5926 26.1457 29.8112 25.5028 30.0363 24.8664C30.2548 24.256 30.1422 23.6975 29.7118 23.217H29.7185Z"
                      fill="white"
                    />
                    <path
                      d="M17.9651 28.6782L16.8394 31.9705C16.7335 32.2757 16.6275 32.581 16.5348 32.8862C16.4223 33.2433 16.5878 33.581 16.9321 33.7109C17.0182 33.7433 17.0977 33.7563 17.1771 33.7563C17.442 33.7563 17.687 33.6005 17.8062 33.3342C17.8326 33.2693 17.8525 33.2109 17.879 33.1394L18.3226 31.8407C18.8921 30.1718 19.4681 28.5093 20.0309 26.8404C20.0839 26.6846 20.1303 26.6456 20.2892 26.6131C21.7989 26.3209 23.3019 26.0222 24.805 25.7235L26.2087 25.4443C26.5133 25.3858 26.8179 25.3209 27.1225 25.2559C27.4271 25.191 27.6191 24.9702 27.6456 24.665C27.672 24.3793 27.5264 24.1325 27.2483 23.9896C27.0563 23.8922 26.8709 23.9312 26.7119 23.9702L24.9573 24.3208C23.3085 24.6455 21.6532 24.9767 20.0045 25.3079C19.8588 25.3404 19.7926 25.3209 19.6999 25.2105C18.8325 24.2299 17.9518 23.2558 17.0778 22.2883L16.0846 21.1843C15.7535 20.8142 15.4291 20.4505 15.0914 20.0869C14.8331 19.8076 14.416 19.7817 14.1313 20.0284C13.8532 20.2622 13.8267 20.6583 14.0584 20.97C14.0916 21.009 14.1313 21.0544 14.1644 21.0934L15.2503 22.3013C16.3693 23.5481 17.4883 24.7949 18.6206 26.0287C18.7729 26.1911 18.7927 26.295 18.7133 26.5092C18.4551 27.2301 18.2034 27.9574 17.9584 28.6847L17.9651 28.6782Z"
                      fill="white"
                    />
                    <path
                      d="M18.7396 20.548C18.8191 20.548 18.8985 20.535 18.9713 20.522L19.8652 20.3467C20.6068 20.2038 21.3418 20.0544 22.0834 19.9051C22.335 19.8531 22.527 19.7427 22.633 19.5804C22.7257 19.444 22.7522 19.2752 22.7124 19.0934C22.6264 18.6972 22.282 18.5024 21.8119 18.5933C21.2756 18.6972 20.7326 18.8011 20.1963 18.9115L19.4613 19.0544C19.17 19.1128 18.8853 19.1648 18.5939 19.2297C18.2827 19.2947 18.0841 19.5349 18.0642 19.8596C18.051 20.1648 18.2165 20.3986 18.5476 20.5155C18.6072 20.5415 18.6734 20.5545 18.7396 20.5545V20.548Z"
                      fill="white"
                    />
                  </svg>
                </div>
                <div
                  class="w-full aspect-[21/44] md:aspect-[29/35] rounded-xl overflow-hidden"
                >
                  <img
                    class="w-full h-full object-cover md:hidden"
                    src="images/mobile_liquidificador_wb2000_gelo.png"
                    alt="liquidificador wb2000"
                  />
                  <img
                    class="hidden w-full h-full object-cover md:block"
                    src="images/desktop_liquidificador_wb2000_gelo.png"
                    alt="liquidificador wb2000"
                  />
                  >
                </div>
              </div>
              <div>
                <h4 class="font-bold text-xl mt-4">Gelo</h4>
                <span class="text-zinc-primary mt-1.5">
                  Perfeito para triturar gelo;
                </span>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section
        class="md:mt-72 mt-96 w-[min(1200px,_90%)] mx-auto font-uni_sans"
      >
        <h2
          class="max-w-[720px] mx-auto text-center font-bold text-2xl md:max-w-[550px]"
        >
          EFICIÊNCIA E DURABILIDADE EM UM DESIGN PREMIUM
        </h2>
        <div class="mt-5 md:grid md:grid-cols-12 items-center">
          <div
            class="hidden md:flex flex-col md:gap-8 md:col-start-1 md:col-end-6 md:row-span-full xl:gap-20"
          >
            <div
              class="bg-gradient-to-l from-white to-gray-light-primary rounded-3xl pl-14 py-6"
            >
              <h3 class="font-bold text-2xl">Na medida certa</h3>
              <p class="mt-2 text-sm">
                Prepare receitas com a consistência ideal de forma prática,
                usando a tampa com dosador.
              </p>
            </div>
            <div
              class="bg-gradient-to-l from-white to-gray-light-primary rounded-3xl pl-14 py-6"
            >
              <h3 class="font-bold text-2xl">Fechamento perfeito</h3>
              <p class="mt-2 text-sm">
                Oferece segurança ao garantir fechamento hermético durante o
                uso, evitando vazamentos.
              </p>
            </div>
            <div
              class="bg-gradient-to-l from-white to-gray-light-primary rounded-3xl pl-14 py-6"
            >
              <h3 class="font-bold text-2xl">Cozinha sem limites</h3>
              <p class="mt-2 text-sm">
                O design prático da jarra de vidro possui 2L de capacidade
                total, perfeita para dar vida à grandes pratos.
              </p>
            </div>
            <div
              class="bg-gradient-to-l from-white to-gray-light-primary rounded-3xl pl-14 py-6"
            >
              <h3 class="font-bold text-2xl">Sempre pronto para uso</h3>
              <p class="mt-2 text-sm">
                As seis lâminas removíveis são projetas para oferecer segurança
                durante o manuseio e a limpeza.
              </p>
            </div>
            <div
              class="bg-gradient-to-l from-white to-gray-light-primary rounded-3xl pl-14 py-6"
            >
              <h3 class="font-bold text-2xl">Resistência e segurança</h3>
              <p class="mt-2 text-sm">
                O design em aço inox proporciona elegância e durabilidade. A
                base possui pés antiderrapantes para mais mobilidade.
              </p>
            </div>
          </div>
          <img
            class="md:col-start-4 md:col-end-13 md:row-span-full -z-10"
            src="images/desktop_liquidificador_2000.gif"
          />
        </div>
        <!-- Splide Mobile -->
        <section
          class="splide mt-5 md:max-w-[80%] mx-auto pb-10 md:hidden"
          aria-labelledby="carousel-heading"
        >
          <div class="splide__track">
            <ul class="splide__list">
              <li class="splide__slide">
                <div
                  class="h-[99%] bg-gradient-to-r from-white to-gray-light-primary rounded-3xl overflow-hidden shadow-bottom"
                >
                  <div class="grid grid-cols-12 h-full gap-1.5">
                    <div class="col-span-7 pl-5 pt-4 pb-2">
                      <h3
                        class="font-bold text-2xl leading-7 line-clamp-2 h-14"
                      >
                        Na medida certa para sua rotina
                      </h3>
                      <p class="mt-3 text-base">
                        Prepare receitas com a consistência ideal de forma
                        prática, usando a tampa com dosador.
                      </p>
                    </div>
                    <div class="col-span-5 grid items-end">
                      <img
                        src="images/mobile_liquidificador_wb2000_dosador.png"
                      />
                    </div>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div
                  class="h-[99%] bg-gradient-to-r from-white to-gray-light-primary rounded-3xl overflow-hidden shadow-bottom"
                >
                  <div class="grid grid-cols-12 h-full gap-1.5">
                    <div class="col-span-7 pl-5 pt-4 pb-2">
                      <h3
                        class="font-bold text-2xl leading-7 line-clamp-2 h-14"
                      >
                        Fechamento perfeito
                      </h3>
                      <p class="mt-3 text-base">
                        Oferece segurança ao garantir fechamento hermético
                        durante o uso, evitando o vazamentos.
                      </p>
                    </div>
                    <div class="col-span-5 h-full">
                      <img
                        class="h-full object-fill"
                        src="images/mobile_liquidificador_wb2000_fechador.png"
                      />
                    </div>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div
                  class="h-[99%] bg-gradient-to-r from-white to-gray-light-primary rounded-3xl overflow-hidden shadow-bottom"
                >
                  <div class="grid grid-cols-12 h-full gap-1.5">
                    <div class="col-span-7 pl-5 pt-4 pb-2">
                      <h3
                        class="font-bold text-2xl leading-7 line-clamp-2 h-14"
                      >
                        Cozinha sem limites
                      </h3>
                      <p class="mt-3 text-base">
                        O design prático da jarra de vidro possui 2L de
                        capacidade total, perfeita para dar vida à grandes
                        pratos.
                      </p>
                    </div>
                    <div class="col-span-5 flex items-end">
                      <img
                        class="h-5/6 object-cover"
                        src="images/mobile_liquidificador_wb2000_copo.png"
                      />
                    </div>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div
                  class="h-[99%] bg-gradient-to-r from-white to-gray-light-primary rounded-3xl overflow-hidden shadow-bottom"
                >
                  <div class="grid grid-cols-12 h-full gap-1.5">
                    <div class="col-span-7 pl-5 pt-4 pb-2">
                      <h3
                        class="font-bold text-2xl leading-7 line-clamp-2 h-14"
                      >
                        Sempre pronto para uso
                      </h3>
                      <p class="mt-3 text-base">
                        As seis lâminas removíveis são projetas para oferecer
                        segurança durante o manuseio e a limpeza.
                      </p>
                    </div>
                    <div class="col-span-5 h-ful">
                      <img
                        class="h-full object-cover"
                        src="images/mobile_liquidificador_wb2000_lamina.png"
                      />
                    </div>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div
                  class="h-[99%] bg-gradient-to-r from-white to-gray-light-primary rounded-3xl overflow-hidden shadow-bottom"
                >
                  <div class="grid grid-cols-12 h-full gap-1.5">
                    <div class="col-span-7 pl-5 pt-4 pb-2">
                      <h3
                        class="font-bold text-2xl leading-7 line-clamp-2 h-14"
                      >
                        Resistência e segurança
                      </h3>
                      <p class="mt-3 text-base">
                        O design em aço inox proporciona elegância e
                        durabilidade. A base possui pés antiderrapantes para
                        mais mobilidade.
                      </p>
                    </div>
                    <div class="col-span-5 h-full">
                      <img
                        class="h-full object-cover md:object-fill"
                        src="images/mobile_liquidificador_wb2000_motor.png"
                      />
                    </div>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </section>
      </section>
      <section
        class="max-w-[1200px] mx-auto mt-11 overflow-hidden md:w-[95%] md:rounded-3xl font-uni_sans"
      >
        <img
          class="hidden md:block"
          src="images/desktop_liquidificador_wb2000_background.png"
          alt="liquidificador wb2000"
        />
        <img
          class="block md:hidden"
          src="images/mobile_liquidificador_wb2000_background.png"
          alt="liquidificador wb2000"
        />
      </section>
      <section
        class="mt-20 w-[min(1200px,_80%)] mx-auto flex flex-col justify-center md:flex-row md:w-[min(1200px,_90%)] md:gap-8 font-uni_sans"
        x-data="{ showText: false }"
      >
        <div class="md:flex-1">
          <div class="relative">
            <div
              class="absolute right-[20%] top-[5%]"
              @click="showText = !showText"
              :class="{ 'rotate-45': showText }"
            >
              <div class="relative">
                <img src="images/desktop_liquidificador_wb2000_button.png" />
                <img
                  class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2"
                  src="images/desktop_liquidificador_wb2000_open_close.png"
                />
              </div>
            </div>
            <div
              class="absolute left-0 bottom-[15%]"
              @click="showText = !showText"
              :class="{ 'rotate-45': !showText }"
            >
              <div class="relative">
                <img src="images/desktop_liquidificador_wb2000_button.png" />
                <img
                  class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2"
                  src="images/desktop_liquidificador_wb2000_open_close.png"
                />
              </div>
            </div>
            <img src="images/desktop_liquidificador_wb2000_copo.png" />
          </div>
        </div>
        <div class="md:flex-1">
          <div
            :class="{ 'hidden': !showText }"
            class="md:max-w-[70%] mx-auto text-lg md:text-base"
          >
            <h2 class="font-bold text-2xl mt-20">SISTEMA DE TRAVA</h2>
            <p class="mt-9 text-zinc-primary">
              A alça possui um sistema de travamento que evita vazamentos e
              acidentes. Ele garante que a tampa fique presa no lugar durante o
              uso.
            </p>
          </div>
          <div
            :class="{ 'hidden': showText }"
            class="md:max-w-[70%] mx-auto text-lg md:text-base"
          >
            <h2 class="font-bold text-2xl mt-20">
              COZINHA RESISTENTE E SEM LIMITES 
            </h2>
            <p class="mt-9 text-zinc-primary">
              Versátil para preparar um cardápio completo de pratos deliciosos,
              o design prático da <strong>jarra de vidro possui 2L</strong> de
              capacidade total, perfeita para dar vida à grandes porções de
              massas, smoothies e molhos em um único recipiente.
            </p>
            <p class="mt-5 text-zinc-primary">
              Além disso, ela não mancha, não absorve odores e é resistente a
              eventuais ranhuras provocadas pelo uso. A jarra e os acessórios
              são compatíveis com lava-louças, garantindo uma limpeza rápida e
              eficiente sem esforço extra. 
            </p>
          </div>
        </div>
      </section>
      <section class="mt-24 max-w-[1200px] mx-auto md:w-[95%] font-uni_sans">
        <div id="splide2" class="splide md:max-w-[90%] mx-auto">
          <div class="splide__track h-full">
            <ul class="splide__list h-full">
              <li class="splide__slide flex flex-col">
                <div class="grow">
                  <img
                    class="object-cover"
                    src="images/desktop_liquidificador_wb2000_receita.png"
                  />
                </div>
                <div class="text-center flex flex-col mt-6 max-w-[90%] mx-auto">
                  <h4 class="font-bold text-xl md:text-2xl">
                    Livro de receitas
                  </h4>
                  <span class="text-zinc-primary mt-5 text-sm h-16"
                    >Exclusivo, inspira você a criar uma variedade de pratos
                    deliciosos.
                  </span>
                </div>
              </li>
              <li class="splide__slide flex flex-col">
                <div class="grow">
                  <img
                    class="object-cover"
                    src="images/desktop_liquidificador_wb2000_antiderrapante.png"
                  />
                </div>
                <div class="text-center flex flex-col mt-6 max-w-[90%] mx-auto">
                  <h4 class="font-bold text-xl md:text-2xl">
                    Pés antiderrapantes
                  </h4>
                  <span class="text-zinc-primary mt-5 text-sm h-16"
                    >Garantem estabilidade durante o preparo dos alimentos para
                    um melhor desempenho.
                  </span>
                </div>
              </li>
              <li class="splide__slide flex flex-col">
                <div class="grow">
                  <img
                    class="object-cover"
                    src="images/desktop_liquidificador_wb2000_BPA_FREE.png"
                  />
                </div>
                <div class="text-center flex flex-col mt-6 max-w-[90%] mx-auto">
                  <h4 class="font-bold text-xl md:text-2xl">BPA FREE</h4>
                  <span class="text-zinc-primary mt-5 text-sm h-16"
                    >Livre de BPA (Bisfenol A), você prepara refeições sem
                    comprometer sua saúde.
                  </span>
                </div>
              </li>
              <li class="splide__slide flex flex-col">
                <div class="grow">
                  <img
                    class="object-cover"
                    src="images/mobile_liquidificador_wb2000_base.png"
                  />
                </div>
                <div class="text-center flex flex-col mt-6 max-w-[90%] mx-auto">
                  <h4 class="font-bold text-xl md:text-2xl">Porta fio</h4>
                  <span class="text-zinc-primary mt-5 text-sm h-16"
                    >Localizada na base do liquidificador, mantêm o cabo
                    elétrico sempre no lugar certo para uma cozinha organizada.
                  </span>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </section>
      <section class="w-[min(1200px,_90%)] mx-auto font-uni_sans mt-10">
        <div class="md:flex flex-row-reverse md:max-w-[90%] md:mx-auto">
          <div class="md:flex-1 md:flex md:items-center">
            <img src="images/desktop_liquidificador_wb2000_morango.png" />
          </div>
          <div class="mt-12 md:flex-1">
            <div
              class="md:flex md:justify-center md:flex-col md:h-full md:max-w-[80%]"
            >
              <h2 class="font-bold text-2xl">SEMPRE PRONTO PARA USO </h2>
              <p class="text-zinc-primary mt-6 text-lg md:text-base">
                Descubra todas as funcionalidades do
                <strong>WAP LIQUIDIFICADOR PROSDÓCIMO WB2000</strong> e prepare
                receitas com praticidade. Faça a escolha mais elegan te e
                inovadora para dar um toque de chef à sua cozinha e de
                cremosidade às receitas.  
              </p>
            </div>
          </div>
        </div>
      </section>
      <section class="w-[min(1200px,_90%)] mx-auto font-uni_sans">
        <div class="md:flex">
          <div class="flex-1 md:flex md:items-center">
            <img src=" images/desktop_liquidificador_wb2000_fogaca.png" />
          </div>
          <div class="flex-1 mt-24 text-xl text-zinc-primary md:text-base">
            <h2 class="font-bold text-black text-2xl">
              CREMOSIDADE IRRESISTÍVEL
            </h2>
            <p class="mt-6 md:mt-4">
              Feito para sua rotina, a combinação única das seis lâminas
              serrilhadas de aço inox e do motor potente garantem cortes
              precisos aos ingredientes. Assim, quem decide a consistência dos
              alimentos é você. Experimente novas receitas com texturas cremosas
              e sabores de dar água na boca.
            </p>
            <h2 class="font-bold mt-8 md:mt-12 text-black text-2xl">
              CARDÁPIO DE CHEF
            </h2>
            <p class="mt-6 md:mt-4">
              Aproveite as receitas assinadas pelo chef Henrique Fogaça e
              prepare pratos deliciosos. São receitas inéditas, perfeitas para
              diversos momentos do seu dia.
            </p>
            <p class="mt-6 md:mt-4">
              Deixe suas refeições ainda melhores! Desperte o chef que há em
              você com a linha de cozinha da WAP.
            </p>
            <a
              class="mt-36 md:mt-10 block max-w-[max-content] mx-auto text-white font-bold bg-red-secondary text-base rounded-full px-8 pb-2 pt-3 leading-6 md:text-base md:mx-0"
              href="#"
              ><span>ACESSE AS RECEITAS DA WAP</span>
            </a>
          </div>
        </div>
      </section>
      <section class="mt-24 max-w-[2000px]">
        <img
          class=""
          src="images/desktop_liquidificador_wb2000_fogaca_background.png"
        />
      </section>
    </main>
    <script>
      document.addEventListener('DOMContentLoaded', function () {
        var splide = new Splide('.splide', {
          arrows: false,
          type: 'loop',
          pagination: true,
          gap: '8px',
        })
        splide.mount()

        var splide2 = new Splide('#splide2', {
          arrows: false,
          perPage: 3,
          type: 'loop',
          gap: '30px',
          pagination: false,
          padding: '10%',
          breakpoints: {
            1024: {
              perPage: 2,
              gap: '30px',
            },
            768: {
              perPage: 1,
              gap: '30px',
              padding: '25%',
            },
          },
        })
        splide2.mount()
      })
    </script>
    <script src="https://cdn.jsdelivr.net/gh/alpinejs/alpine@v2.x.x/dist/alpine.min.js"></script>
    <script src="./javascript/senders.js"></script>
  </body>
</html>

`

let iframe = document.getElementById('product-iframe-page')
iframe.setAttribute('srcdoc', htmlContent)
